import java.awt.event.ActionListener;

public interface vistaJarra {
	public static final String INICIAR = "INICIAR";
	public static final String LLENAR_A = "LLENAR_A";
	public static final String LLENAR_B = "LLENAR_B";
	public static final String VACIAR_A = "VACIAR_A";
	public static final String VACIAR_B = "VACIAR_B";
	public static final String VOLCAR_A_EN_B = "VOLCAR_A_EN_B";
	public static final String VOLCAR_B_EN_A = "VOLCAR_B_EN_A";
	public static final String FINALIZAR = "FINALIZAR";
	/**
	* Pasamos el controlador.
	*/
	public void controlador(ActionListener ctr);
	/**
	* Obtenemos la capacidad inicial de la jarra A.
	* @return int con la capacidad inicial de la jarra A.
	*/
	public int capacidadInicialA();
	/**
	* Obtenemos la capacidad inicial de la jarra B
	* @return int con la capacidad inicial de la jarra B.
	*/
	public int capacidadInicialB();
	/**
	* Mostramos un mensaje de error.
	* @param mensaje
	* String con el mensaje a mostrar.
	*/
	public void error(String mensaje);
	/**
	* Mostramos un mensaje de informacin.
	* @param mensaje
	* String con el mensaje a mostrar.
	*/
	public void ok(String mensaje);
	/**
	* Habilitamos o deshabilitamos el modo inicializacin de jarras o trasvases
	* @param b
	* true para habilitar el modo inicializacin; false para el modo trasvases
	*/
	public void habilitarInicio(boolean b);
	/**
	* Establecemos la capacidad de la jarra A.
	* @param c
	* int con la capacidad de la jarra A
	*/
	public void capacidadA(int c);
	/**
	* Establecemos la capacidad de la jarra B.
	* @param c
	* int con la capacidad de la jarra B.
	*/
	public void capacidadB(int c);
	/**
	* Establecemos el contenido de la jarra A.
	* @param c
	* int con el contenido de la jarra A.
	*/
	public void contenidoA(int c);
	/**
	* Establecemos el contenido de la jarra B.
	* @param c
	* int con el contenido de la jarra B.
	*/
	public void contenidoB(int c);
	/**
	* Aadimos un mensaje al histrico.
	* @param mensaje
	* String con el mensaje a aadir.
	*/
	public void aadirAHistrico(String mensaje);
	/**
	* Limpiamos el histrico.
	*/
	public void limpiar();
	}