import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionListener;

public class PanelJarras1 extends JPanel implements vistaJarra{
	
	private JButton startCapacities, FillLeft, FillRight, VoidLeft, VoidRight, Finish, VolcateA, VolcateB;
	private JLabel JARRA_A, JARRA_B, CONTENIDO_A, CONTENIDO_B, CAPACIDAD_A, CAPACIDAD_B, MENSAJE;
	private JTextField jar_A, jar_B, cap_A, cap_B, cont_A, cont_B;
	private JTextArea LOG;
	
	public PanelJarras1(){
		 
		 setLayout(new GridLayout(2, 1));
		 
		 ImageIcon i1 = new ImageIcon("go-next.jpg");
		 ImageIcon i2 = new ImageIcon("go-previous.jpg");
		 
		 startCapacities = new JButton("Iniciar Capacidades");
		 FillLeft = new JButton("Llenar");
		 FillRight = new JButton("Llenar");
		 VoidLeft = new JButton("Vaciar");
		 VoidRight = new JButton("Vaciar");
		 Finish = new JButton("Finalizar");
		 VolcateA = new JButton(i1);
		 VolcateB = new JButton(i2);
		 
		 
		 JARRA_A = new JLabel("Jarra A");
		 JARRA_B = new JLabel("Jarra B");
		 CONTENIDO_A = new JLabel("Contenido");
		 CONTENIDO_B = new JLabel("Contenido");
		 CAPACIDAD_A = new JLabel("Capacidad");
		 CAPACIDAD_B = new JLabel("Capacidad");
		 MENSAJE = new JLabel("Bienvenido a Jarras Launcher 3000");
		 
		 jar_A = new JTextField(5);
		 jar_B = new JTextField(5);
		 cap_A = new JTextField();
		 cap_B = new JTextField();
		 cont_A = new JTextField();
		 cont_B = new JTextField();
		 
		 cap_A.setEditable(false);
		 cap_B.setEditable(false);
		 cont_A.setEditable(false);
		 cont_B.setEditable(false);
		 
		 LOG = new JTextArea();
		 LOG.setForeground(Color.green);
		 LOG.setEditable(false);
		 
		 JPanel pnorte = new JPanel();
		 pnorte.setLayout(new GridLayout(4, 3));
		 
		 JScrollPane psur = new JScrollPane();
		 psur.setLayout(new ScrollPaneLayout());
		 
		 JPanel psur2 = new JPanel();
		 psur2.setLayout(new BorderLayout());
		 //izquierdo superior
		 JPanel JARRA_A_jar_A = new JPanel();
		 JARRA_A_jar_A.add(JARRA_A, BorderLayout.WEST);
		 JARRA_A_jar_A.add(jar_A, BorderLayout.EAST);
		 //derecho superior
		 JPanel JARRA_B_jar_B = new JPanel();
		 JARRA_B_jar_B.add(JARRA_B,BorderLayout.WEST);
		 JARRA_B_jar_B.add(jar_B, BorderLayout.EAST);
		 //izquierdo central
		 JPanel centroIZ = new JPanel();
		 centroIZ.setLayout(new GridLayout(2,2));
		 centroIZ.add(CONTENIDO_A);
		 centroIZ.add(cont_A);
		 centroIZ.add(CAPACIDAD_A);
		 centroIZ.add(cap_A);
		 //derecho central
		 JPanel centroDE = new JPanel();
		 centroDE.setLayout(new GridLayout(2,2));
		 centroDE.add(CONTENIDO_B);
		 centroDE.add(cont_B);
		 centroDE.add(CAPACIDAD_B);
		 centroDE.add(cap_B);
		 
		 pnorte.add(JARRA_A_jar_A);
		 pnorte.add(startCapacities);
		 pnorte.add(JARRA_B_jar_B);
		 pnorte.add(FillLeft);
		 pnorte.add(VolcateA);
		 pnorte.add(FillRight);
		 pnorte.add(centroIZ);
		 pnorte.add(VolcateB);
		 pnorte.add(centroDE);
		 pnorte.add(VoidLeft);
		 pnorte.add(Finish);
		 pnorte.add(VoidRight);
		 
		 psur.setViewportView(LOG);
		 psur.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		 psur.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		 
		 psur2.add(psur, BorderLayout.CENTER);
		 psur2.add(MENSAJE, BorderLayout.SOUTH);
		 
		 add(pnorte);
		 add(psur2);
		 
	 }

	@Override
	public void aadirAHistrico(String mensaje) {
		// TODO Auto-generated method stub
		MENSAJE.setText(mensaje);
		MENSAJE.setForeground(Color.BLUE);
		
	}

	@Override
	public void capacidadA(int c) {
		// TODO Auto-generated method stub
		cap_A.setText(""+c);
		cap_A.setEditable(false);
		
	}

	@Override
	public void capacidadB(int c) {
		// TODO Auto-generated method stub
		cap_B.setText(""+c);
		cap_B.setEditable(false);
	}

	@Override
	public int capacidadInicialA() {
/*Obtenemos la capacidad inicial de la jarra B
	* @return int con la capacidad inicial de la jarra B.
 * 
 * */
		// TODO Auto-generated method stub
		return Integer.parseInt(jar_A.getText());
	}

	@Override
	public int capacidadInicialB() {
		// TODO Auto-generated method stub
		return Integer.parseInt(jar_B.getText());
	}

	@Override
	public void contenidoA(int c) {
		// TODO Auto-generated method stub
		cont_A.setText(""+c);
	}

	@Override
	public void contenidoB(int c) {
		// TODO Auto-generated method stub
		cont_B.setText(""+c);
	}

	@Override
	public void controlador(ActionListener ctr) {
		// TODO Auto-generated method stub
		/*
		 * 	ingresarJB.addActionListener(ctr);
			ingresarJB.setActionCommand(INGRESO);
		 */
		 startCapacities.addActionListener(ctr);
		 startCapacities.setActionCommand("INICIAR");
		 FillLeft.addActionListener(ctr);
		 FillLeft.setActionCommand("LLENAR_A");
		 FillRight.addActionListener(ctr);
		 FillRight.setActionCommand("LLENAR_B");
		 
		 VoidLeft.addActionListener(ctr);
		 VoidLeft.setActionCommand("VACIAR_A");
		 VoidRight.addActionListener(ctr);
		 VoidRight.setActionCommand("VACIAR_B");
		 Finish.addActionListener(ctr);
		 Finish.setActionCommand("FINALIZAR");
		 VolcateA.addActionListener(ctr);
		 VolcateA.setActionCommand("VOLCAR_A_EN_B");
		 VolcateB.addActionListener(ctr);
		 VolcateB.setActionCommand("VOLCAR_B_EN_A");
		
	}

	@Override
	public void error(String mensaje) {
		// TODO Auto-generated method stub
		MENSAJE.setText(mensaje);
		MENSAJE.setForeground(Color.RED);
	}

	@Override
	public void habilitarInicio(boolean b) {
		// TODO Auto-generated method stub
		 startCapacities.setEnabled(!b);
		 jar_A.setEditable(!b);
		 jar_B.setEditable(!b);
		 FillLeft.setEnabled(b);
		 FillRight.setEnabled(b);
		 VoidLeft.setEnabled(b);
		 VoidRight.setEnabled(b);
		 Finish.setEnabled(b);
		 VolcateA.setEnabled(b);
		 VolcateB.setEnabled(b);
	}

	@Override
	public void limpiar() {
		// TODO Auto-generated method stub
		LOG.setText("");
	}

	@Override
	public void ok(String mensaje) {
		// TODO Auto-generated method stub
		LOG.append(mensaje + "\n");
	}
}
