/**
 * En esta clase "simulamos" el uso de una jarra de agua. Suponemos que
 * disponemos de una fuente y un sumidero de tal manera que podemos llenar la
 * jarra (entera) y vaciarla (entera tambin). Otra operacin permitida es
 * llenar una jarra con el agua que haya en otra jarra (sin que llegue a
 * rebosar).
 *
 * @author Fco. Durn, Fco. Gutirrez, E. Pimentel, A. Rossi
 */

public class Jarra {
	/**
	 * Contenido de lquido (en litros) de la jarra.
	 * @uml.property  name="contenido"
	 */
	private int contenido;

	/**
	 * Capacidad de la jarra (en litros).
	 * @uml.property  name="capacidad"
	 */
	private final int capacidad;

	/**
	 * Creamos una jarra a partir de su capacidad.
	 * 
	 * @param capacidadInicial
	 *            capacidad que va a tener la jarra.
	 */
	public Jarra(int capacidadInicial) {
		if (capacidadInicial <= 0) {
			throw new RuntimeException(
					"La capacidad de una jarra debe ser un nmero mayor que cero.");
		}
		capacidad = capacidadInicial;
		contenido = 0;
	}

	/**
	 * Devolvemos la capacidad de la jarra.
	 * 
	 * @return int con la capacidad de la jarra.
	 */
	public int capacidad() {
		return capacidad;
	}

	/**
	 * Devolvemos la cantidad de lquido que hay en la jarra.
	 * 
	 * @return int con la cantidad de lquido que hay en la jarra.
	 */
	public int contenido() {
		return contenido;
	}

	/**
	 * Llenamos por completo la jarra.
	 */
	public void llena() {
		contenido = capacidad;
	}

	/**
	 * Vaciamos por completo la jarra.
	 */
	public void vaca() {
		contenido = 0;
	}

	/**
	 * Llenamos la jarra con el contenido de otra jarra. Llenamos hasta
	 * que no quepa ms agua o hasta que la otra jarra se vace.
	 * 
	 * @param j
	 *            Jarra desde la que volcar el agua.
	 */
	public void llenaDesde(Jarra j) {
		int cantidadMnima = Math.min(capacidad - contenido, j.contenido());
		contenido = contenido + cantidadMnima;
		j.contenido = j.contenido - cantidadMnima;
	}

	/**
	 * Representamos una jarra mediante un par indicando contenido y capacidad.
	 */
	public String toString() {
		return "(" + contenido + ", " + capacidad + ")";
	}
}