import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CtrJarra implements ActionListener{
	private vistaJarra vistaJarra;
	private Jarra jarra1, jarra2;
	public CtrJarra(vistaJarra vj){
		vistaJarra = vj;
		vistaJarra.habilitarInicio(false);
	}
	public void actionPerformed(ActionEvent evento){
		String comando = evento.getActionCommand();
		if(comando.equals(vistaJarra.INICIAR)){
			if(vistaJarra.capacidadInicialA() > 0 || vistaJarra.capacidadInicialB() > 0){
				jarra1 = new Jarra(vistaJarra.capacidadInicialA());
				jarra2 = new Jarra(vistaJarra.capacidadInicialB());
				vistaJarra.habilitarInicio(true);
				vistaJarra.capacidadA(jarra1.capacidad());
				vistaJarra.capacidadB(jarra2.capacidad());
				vistaJarra.contenidoA(0);
				vistaJarra.contenidoB(0);
				vistaJarra.ok("Se crearon 2 jarras, una de capacidad "+jarra1.capacidad()+" y otra de capacidad "+jarra2.capacidad()+", ambas vacias");
				vistaJarra.aadirAHistrico("La jarra se creo con exito");
			}else{
				vistaJarra.error("No se puede crear una jarra de tamao menor que 1");
			}
		}
		if(comando.equals(vistaJarra.LLENAR_A)){
			if(jarra1.contenido() == jarra1.capacidad()){
				vistaJarra.error("La jarra A ya esta a tope");
			}else{
				jarra1.llena();
				vistaJarra.contenidoA(jarra1.capacidad());
				vistaJarra.ok("Se lleno la jarra A con "+jarra1.capacidad()+" litros.");
			}
		}
		if(comando.equals(vistaJarra.LLENAR_B)){
			if(jarra2.contenido() == jarra2.capacidad()){
				vistaJarra.error("La jarra B ya esta a tope");
			}else{
				jarra2.llena();
				vistaJarra.contenidoB(jarra2.capacidad());
				vistaJarra.ok("Se lleno la jarra B con "+jarra2.capacidad()+" litros.");
			}
		}
		if(comando.equals(vistaJarra.VACIAR_A)){
			if(jarra1.contenido() == 0){
				vistaJarra.error("La jarra A ya esta vacia");
			}else{
				jarra1.vaca();
				vistaJarra.contenidoA(0);
				vistaJarra.ok("Se vacio la jarra A");
			}
		}
		if(comando.equals(vistaJarra.VACIAR_B)){
			if(jarra2.contenido() == 0){
				vistaJarra.error("La jarra B ya esta vacia");
			}else{
				jarra2.vaca();
				vistaJarra.contenidoB(0);
				vistaJarra.ok("Se vacio la jarra B");
			}
		}
		if(comando.equals(vistaJarra.VOLCAR_A_EN_B)){
			int a = jarra2.contenido();
			jarra2.llenaDesde(jarra1);
			int b = jarra2.contenido();
			vistaJarra.contenidoA(jarra1.contenido());
			vistaJarra.contenidoB(jarra2.contenido());
			if((b-a) == 0){
				vistaJarra.error("No se pudo volcar nada");
			}else{
				vistaJarra.ok("Se volcaron "+(b-a)+" litros desde la jarra A en la jarra B");
			}
		}
		if(comando.equals(vistaJarra.VOLCAR_B_EN_A)){
			int a = jarra1.contenido();
			jarra1.llenaDesde(jarra2);
			int b = jarra1.contenido();
			vistaJarra.contenidoB(jarra2.contenido());
			vistaJarra.contenidoA(jarra1.contenido());
			if((b-a) == 0){
				vistaJarra.error("No se pudo volcar nada");
			}else{
				vistaJarra.ok("Se volcaron "+(b-a)+" litros desde la jarra B en la jarra A");
			}
		}
		if(comando.equals(vistaJarra.FINALIZAR)){
			vistaJarra.habilitarInicio(false);
		}
	}
	
}