import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;


public class CtrCuenta implements ActionListener{
	private VistaCuenta vistaCuenta;
	private Cuenta cuenta;
	public CtrCuenta(VistaCuenta vc, Cuenta c){
		vistaCuenta = vc;
		cuenta = c;
		vistaCuenta.saldo(cuenta.saldo());
	}
	public void actionPerformed(ActionEvent evento){
		String comando = evento.getActionCommand();
		if(comando.equals(VistaCuenta.INGRESO)){
			double cantidad = vistaCuenta.obtenerCantidad();
			cuenta.ingresa(cantidad);
			vistaCuenta.saldo(cuenta.saldo());
			vistaCuenta.mensaje("Se ingres la cantidad");
			vistaCuenta.borrar();
		}
		if(comando.equals("NUMERO")){
			JButton c=(JButton)evento.getSource();
			vistaCuenta.texto(c.getText());
		}
		if(comando.equals("BORRAR")){
			vistaCuenta.borrar();
		}
		if(comando.equals(VistaCuenta.GASTO)){
			double cantidad = vistaCuenta.obtenerCantidad();
			double extraido = cuenta.extrae(cantidad);
			vistaCuenta.saldo(cuenta.saldo());
			if(extraido == cantidad){
				vistaCuenta.mensaje("La operacin fue realizada correctamente");
			}else{
				vistaCuenta.mensaje("Slo se pudo extraer "+extraido);
			}
		}
		if(comando.equals(VistaCuenta.SALDO)){
			vistaCuenta.saldo(cuenta.saldo());
			vistaCuenta.mensaje("El saldo se ha consultado con xito");
		}
	}
}
